<?php  
/* 
Plugin Name: VC Particles 3D Background
Version: 1.1
Author: Boom-Apps
Author URI: http://codecanyon.net/user/boom-apps
Description: particle.js backgrounds for Visual Composer
*/  

class VC_Particles3D_Background {
	function backendElement() {
		vc_map( array(
            "name" => __("VC Particles 3D Background", 'vc_extend'),
            "description" => __("Creative backgrounds!", 'vc_extend'),
            "base" => "vc_particles3d_background",
            "class" => "",
            "controls" => "full",
            "params" => array(
              array("save_always" => true, "type" => "textarea", "holder" => "div", "class" => "", "heading" => "Id - unique per page", "param_name" => "theid", "value" => "vcparticles3dbackground_".time()."_".rand(100000,999999999) ),
              array("save_always" => true, "type" => "colorpicker",  "class" => "", "heading" => "Particle color", "param_name" => "particlecolor", "value" => "#ffffff", ),
              array("save_always" => true, "type" => "textarea",  "class" => "", "heading" => "Particle opacity", "param_name" => "particleopacity", "value" => "0.50", "description" => "Float (0.00-1.00)" ),
              array("save_always" => true, "type" => "colorpicker",  "class" => "", "heading" => "Line color", "param_name" => "linecolor", "value" => "#ffffff"),
              array("save_always" => true, "type" => "textarea",  "class" => "", "heading" => "Line opacity", "param_name" => "lineopacity", "value" => "0.1", "description" => "Float (0.00-1.00)" ),
              array("save_always" => true, "type" => "textarea",  "class" => "", "heading" => "Particles ammount", "param_name" => "particlesammount", "value" => "150", "description" => "Float (0-1000)" ),
              array("save_always" => true, "type" => "textarea",  "class" => "", "heading" => "Move speed", "param_name" => "movespeed", "value" => "0.35", "description" => "Float (0.00-2.00)" ),
              array("save_always" => true, "type" => "textarea",  "class" => "", "heading" => "Camera max move (X)", "param_name" => "cameraxmovemax", "value" => "6.00", "description" => "Float (0.00-10.00)" ),
              array("save_always" => true, "type" => "textarea",  "class" => "", "heading" => "Camera max move (Y)", "param_name" => "cameraymovemax", "value" => "3.50", "description" => "Float (0.00-10.00)" ),
              array("save_always" => true, "type" => "textarea",  "class" => "", "heading" => "Camera elastic move ratio (X)", "param_name" => "cameraxmoveelastic", "value" => "0.02", "description" => "Float (0.01-1.00)" ),
              array("save_always" => true, "type" => "textarea",  "class" => "", "heading" => "Camera elastic move ratio (Y)", "param_name" => "cameraymoveelastic", "value" => "0.02", "description" => "Float (0.01-1.00)" ),
              array("save_always" => true, "type" => "textarea",  "class" => "", "heading" => "Particle Size", "param_name" => "particlesize", "value" => "5", "description" => "Integer (1-50)" ),
             )
        ) );
		
	}

	function theShortcode($Atts, $Content = null) {
		wp_enqueue_script(  array( 'jquery','three-js','three-js-canvas-renderer','three-js-projector','3d-lines-animation','vc-particles3d-background' ) );
		
		$Return = '<div id="'.$Atts['theid'].'" ';
		foreach ($Atts as $AttN => $AttV) {
			$Return .= 'data-'.str_replace("_","-",$AttN).'="'.$AttV.'" ';
		}
		$Return .= 'class="vc-particles3d-background" style="display:none;"></div>';
		
		return $Return;
	}
	
	
	function custom_css_classes_for_vc_row_and_vc_column( $class_string, $tag ) {
	  if ( $tag == 'vc_row' || $tag == 'vc_row_inner' ) {
		if (strpos($class_string,'boomapps_vcrow') == false) { $class_string = $class_string . " boomapps_vcrow"; } 
	  }
	  if ( $tag == 'vc_column' || $tag == 'vc_column_inner' ) {
		if (strpos($class_string,'boomapps_vccolumn') == false) { $class_string = $class_string . " boomapps_vccolumn"; }
	  }
	  return $class_string; 
	}
	
	function registerStuff() {
		add_shortcode( 'vc_particles3d_background', array($this,'theShortcode') );	
		$this->backendElement();		
	}
	function registerScripts() {
		 wp_register_script( '3d-lines-animation', plugins_url('_3rdparty/3d-lines-animation.js',__FILE__ ) );
		 wp_register_script( 'vc-particles3d-background', plugins_url('vcparticles3dbackground.js',__FILE__ ) );
		 wp_register_script( 'three-js', plugins_url('_3rdparty/three.min.js',__FILE__ ) );
		 wp_register_script( 'three-js-canvas-renderer', plugins_url('_3rdparty/three.canvas-renderer.min.js',__FILE__ ) );
		 wp_register_script( 'three-js-projector', plugins_url('_3rdparty/three.projector.min.js',__FILE__ ) );
		
	}
	function __construct() {
		add_action( 'wp_enqueue_scripts', array( $this, 'registerScripts') );
		add_action( 'init', array( $this, 'registerStuff') );	
		add_filter( 'vc_shortcodes_css_class', array($this,'custom_css_classes_for_vc_row_and_vc_column'), 10, 2 );
	}
}


/* Let's go! */
if (function_exists('vc_map')) {
	new VC_Particles3D_Background;
}

